#ifdef GL_ES
attribute vec2 inVertex;
attribute vec2 inTexCoord0;

varying	vec3 lightVector, halfVector;
varying vec2 vTexCoord;
varying vec2 vRotTexCoord;
#else
in vec2 inVertex;
in vec2 inTexCoord0;

out	vec3 lightVector, halfVector;
out vec2 vTexCoord;
out vec2 vRotTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 textureRotationMatrix;

uniform vec3 lightSource1;
uniform vec3 lightSource1HV;

void main()
{
	mat3 mvm;
	mvm[0] = modelViewMatrix[0].xyz;
	mvm[1] = modelViewMatrix[1].xyz;
	mvm[2] = modelViewMatrix[2].xyz;

  lightVector = normalize((textureRotationMatrix * vec4(normalize(lightSource1 * mvm), 0.0)).rgb);
  halfVector = normalize((textureRotationMatrix * vec4(normalize(lightSource1HV * mvm), 0.0)).rgb);

	vTexCoord = inTexCoord0;
	vRotTexCoord = (textureRotationMatrix * vec4(inTexCoord0, 0.0, 1.0)).xy;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 0.0, 1.0);
}
